import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { C as ChangeEmail, a as ChangePassword, F as ForgetPassword } from "./forget-password-BB_H3NGg.js";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { g as getQueryParams } from "./route-DlE7FdTW.js";
import { usePage, Head, router } from "@inertiajs/react";
import { nanoid } from "nanoid";
import UpdateProfile from "./update-profile-DxvyCGEc.js";
import "./input-error-CBKwRgzN.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./card-DBOrqCcU.js";
import "react";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "class-variance-authority";
import "./loading-button-C9msud_X.js";
import "lucide-react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "@radix-ui/react-tabs";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-CP8LgHIG.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
import "./tag-input-9nM54QOY.js";
import "@yaireo/tagify";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
const Account = ({ instructor, translate }) => {
  const page = usePage();
  const params = getQueryParams(page.url);
  const { button, settings } = translate;
  const tabs = [
    {
      id: nanoid(),
      slug: "profile-update",
      title: button.profile_update,
      Component: () => /* @__PURE__ */ jsx(UpdateProfile, { instructor })
    },
    {
      id: nanoid(),
      slug: "change-email",
      title: button.change_email,
      Component: ChangeEmail
    },
    {
      id: nanoid(),
      slug: "change-password",
      title: button.change_password,
      Component: ChangePassword
    },
    {
      id: nanoid(),
      slug: "forget-password",
      title: button.forget_password,
      Component: ForgetPassword
    }
    // {
    //    id: nanoid(),
    //    slug: 'delete-account',
    //    title: 'Delete Account',
    //    Component: DeleteUser,
    // },
  ];
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(Head, { title: settings.account_settings }),
    /* @__PURE__ */ jsxs(Tabs, { value: params["tab"] ?? tabs[0].slug, className: "grid grid-rows-1 gap-5 md:grid-cols-4 md:px-3", children: [
      /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list", children: tabs.map(({ id, slug, title }) => /* @__PURE__ */ jsx(
        TabsTrigger,
        {
          value: slug,
          className: "horizontal-tabs-trigger",
          onClick: () => router.get(
            route("settings.account", {
              tab: slug
            })
          ),
          children: title
        },
        id
      )) }) }),
      /* @__PURE__ */ jsx("div", { className: "md:col-span-3", children: tabs.map(({ id, slug, Component }) => /* @__PURE__ */ jsx(TabsContent, { value: slug, className: "m-0", children: /* @__PURE__ */ jsx(Component, {}) }, id)) })
    ] })
  ] });
};
Account.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Account as default
};
